/*
 * Decompiled with CFR 0.152.
 */
package dioscuri;

import dioscuri.Constants;
import dioscuri.Emulator;
import dioscuri.GUI;
import dioscuri.config.ConfigController;
import dioscuri.interfaces.Module;
import dioscuri.module.cpu.CPU;
import dioscuri.module.memory.Memory;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class AbstractInstructionTest {
    public static Logger logger = Logger.getLogger(AbstractInstructionTest.class.getClass().getName());
    public final Emulator emu = new Emulator(new DummyGUI());
    public final CPU cpu;
    public final Memory mem;
    private final String rootTestASMfiles = "src/test-asm/";

    public AbstractInstructionTest(int n, String string) throws Exception {
        this.emu.emuConfig = ConfigController.loadFromXML(new File(Constants.DEFAULT_CONFIG_XML));
        this.emu.moduleConfig = this.emu.emuConfig.getArchitecture().getModules();
        this.emu.setupEmu();
        this.mem = (Memory)this.emu.getModule(Module.Type.MEMORY);
        this.cpu = (CPU)this.emu.getModule(Module.Type.CPU);
        this.cpu.setDebugMode(true);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new DataInputStream(new FileInputStream(new File("src/test-asm/" + string))));
        byte[] byArray = new byte[bufferedInputStream.available()];
        bufferedInputStream.read(byArray, 0, byArray.length);
        bufferedInputStream.close();
        this.mem.setBytes(n, byArray);
    }

    class DummyGUI
    implements GUI {
        DummyGUI() {
        }

        @Override
        public JFrame asJFrame() {
            return null;
        }

        @Override
        public dioscuri.config.Emulator getEmuConfig() {
            return null;
        }

        @Override
        public String getConfigFilePath() {
            return null;
        }

        @Override
        public void notifyGUI(int n) {
        }

        @Override
        public void updateGUI(int n) {
        }

        @Override
        public void setScreen(JPanel jPanel) {
        }

        @Override
        public boolean setMouseEnabled() {
            return false;
        }

        @Override
        public boolean setMouseDisabled() {
            return false;
        }

        @Override
        public void setCpuTypeLabel(String string) {
        }
    }
}

